import wx
from   button import Button

#-------------------------------------------------------------------------------
# Constants
#-------------------------------------------------------------------------------
BTN_RND_RECTANGLE = 20   # Define new appearance constants
BTN_RECTANGLE     = 21


class Frame(wx.Frame):
    def __init__(self):
        super().__init__(None, -1, "Simple demo - 4", size=(300, 500),
                         style=wx.DEFAULT_FRAME_STYLE |
                         wx.NO_FULL_REPAINT_ON_RESIZE)

        # Initialisation  
        self.focused_ctrl = False
        
        self.panel = wx.Panel(self)
        self.panel.SetBackgroundColour("#202020")
        self.panel.SetDoubleBuffered(True)

        # System font size
        ft_size = self.GetButtonFontSize()
        
        self.button13 = Button(self.panel, id=-1, label="Button 13", normalLabelColour="#ec008c",
                               hoverLabelColour="#00aeef", pressedLabelColour="#faa61a",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_NORMAL,
                               normalBtnColour=(wx.Colour(0, 0, 0, 0), wx.Colour(0, 0, 0, 0)),
                               hoverBtnColour=wx.Colour(0, 0, 0, 0),
                               pressedBtnColour=wx.Colour(0, 0, 0, 0), disabledBtnColour=wx.Colour(0, 0, 0, 0),
                               borderColour=wx.Colour(0, 0, 0, 0),
                               focusColour=wx.Colour(255, 255, 255, 0),
                               indicatorColour="magenta", appearance=BTN_RND_RECTANGLE,
                               borderSize=1, size=(100, 30), pos=(100, 100),
                               )
        #self.button13.SetToolTip("This is button 13")
        #self.button13.Enable(False)
        self.button13.SetFocus()

        self.button14 = Button(self.panel, id=-1, label="Button 14", normalLabelColour="#838383",
                               hoverLabelColour="magenta", pressedLabelColour="#6450cd",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                               normalBtnColour=(wx.Colour(0, 0, 0, 0), wx.Colour(0, 0, 0, 0)),
                               hoverBtnColour=wx.Colour(0, 0, 0, 0),
                               pressedBtnColour=wx.Colour(0, 0, 0, 0), disabledBtnColour=wx.Colour(0, 0, 0, 0),
                               borderColour=wx.Colour(0, 0, 0, 0),
                               focusColour=wx.Colour(150, 150, 150, 255),
                               indicatorColour=wx.Colour(0, 0, 0, 255), appearance=BTN_RND_RECTANGLE,
                               borderSize=0, size=(110, 30), pos=(100, 200),
                               image="./bitmaps/folder.png", 
                               image_position='left' 
                               )
        #self.button14.SetToolTip("This is button 14")
        #self.button14.Enable(False)

        self.button15 = Button(self.panel, id=-1, label="Button 15", normalLabelColour="#838383",
                               hoverLabelColour="magenta", pressedLabelColour="#6450cd",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                               normalBtnColour=(wx.Colour(0, 0, 0, 0), wx.Colour(0, 0, 0, 0)),
                               hoverBtnColour=wx.Colour(0, 0, 0, 0),
                               pressedBtnColour=wx.Colour(0, 0, 0, 0), disabledBtnColour=wx.Colour(0, 0, 0, 0),
                               borderColour="#8770fe",
                               focusColour="#8770fe",
                               indicatorColour=wx.Colour(0, 0, 0, 0), appearance=BTN_RND_RECTANGLE,
                               borderSize=1, size=(110, 30), pos=(100, 300),
                               image="./bitmaps/folder.png", 
                               image_position='left' 
                               )
        #self.button15.SetToolTip("This is button 15")
        #self.button15.Enable(False)
        
        self.button13.Bind(wx.EVT_BUTTON, self.OnButton)  # Bind the event handler to each button
        self.button14.Bind(wx.EVT_BUTTON, self.OnButton)  # Bind the event handler to each button
        self.button15.Bind(wx.EVT_BUTTON, self.OnBtnClose)
        self.panel.Bind(wx.EVT_LEFT_DOWN, self.OnPanelClick)  # Event to manage focus when clicking on the panel 
        self.Bind(wx.EVT_BUTTON, self.OnControlClick)
        self.Bind(wx.EVT_ACTIVATE, self.OnActivate)  # Event to handle focus when clicking on the title bar
        
    def GetButtonFontSize(self):
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font_size = font.GetPointSize()
    
        # Dictionary for size adjustments by platform  
        platform_adjustments = {
            '__WXMSW__': 1,
            '__WXGTK__': -1,
            '__WXMAC__': 2  
        }
    
        # Use get() to get the fit, or 0 if the platform is not specified
        adjustment = platform_adjustments.get(wx.Platform, 0)
  
        return font_size + adjustment  # Returns the adjusted font size

    def OnControlClick(self, event):
        # Manage focus on controls  
        self.focused_ctrl = event.GetEventObject()
        self.focused_ctrl.SetFocus()
        
    def OnPanelClick(self, event):
        # Set focus on the control when the panel is clicked   
        self.button15.SetFocus()
        # Set focus on the control when the window is activated
        if self.focused_ctrl:  # Give focus to the last selected control  
            self.focused_ctrl.SetFocus()
        event.Skip()  # Allows events to continue to be processed

    def OnActivate(self, event):
        if event.GetActive():
            self.button15.SetFocus()
            # Set focus on the control when the window is activated  
            if self.focused_ctrl:  # Give focus to the last selected control  
                self.focused_ctrl.SetFocus()
            self.Refresh()
        event.Skip()  # Allows events to continue to be processed
        
    def OnButton(self, event):
        obj = event.GetEventObject()
        label = obj.GetLabel().strip()
        print(label, "pressed")
        event.Skip()

    def OnBtnClose(self, event):
        print("Close dialog")
        self.Close()
        
app = wx.App()
frame = Frame()
frame.Show()
app.MainLoop()
