import wx
from   button import Button

#-------------------------------------------------------------------------------
# Constants
#-------------------------------------------------------------------------------
BTN_RND_RECTANGLE = 20   # Define new appearance constants
BTN_RECTANGLE     = 21


class Frame(wx.Frame):
    def __init__(self):
        super().__init__(None, -1, "Simple demo - 3", size=(340, 600),
                         style=wx.DEFAULT_FRAME_STYLE |
                         wx.NO_FULL_REPAINT_ON_RESIZE)

        # Initialisation  
        self.focused_ctrl = False
        
        self.panel = wx.Panel(self)
        self.panel.SetBackgroundColour("#202020")
        self.panel.SetDoubleBuffered(True)

        # System font size
        ft_size = self.GetButtonFontSize()
        
        self.button9 = Button(self.panel, id=-1, label="Button 9", normalLabelColour="#000000",
                              hoverLabelColour="#000000", pressedLabelColour="#000000",
                              font_size=ft_size, font_weight=wx.FONTWEIGHT_NORMAL,
                              normalBtnColour=(wx.Colour(254, 198, 3, 255), wx.Colour(221, 140, 14, 255)), 
                              hoverBtnColour="#fec603", 
                              pressedBtnColour="#f45d1a", disabledBtnColour="#838383",
                              borderColour="#ffffff",
                              focusColour="#ffffff",
                              indicatorColour="#000000", appearance=BTN_RND_RECTANGLE, 
                              borderSize=1, size=(100, 30), pos=(100, 110),
                              )
        #self.button9.SetToolTip("This is button 9")
        #self.button9.Enable(False)
        self.button9.SetFocus()
        
        self.button10 = Button(self.panel, id=-1, label="Button 10\nwith image\nand\nmultiline",
                               normalLabelColour="#ffffff", hoverLabelColour="#ffffff", pressedLabelColour="#6450cd",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                               normalBtnColour=(wx.Colour(135, 112, 254, 255), wx.Colour(135, 112, 254, 255)),
                               hoverBtnColour="#6450cd",
                               pressedBtnColour="#ffffff", disabledBtnColour="#838383",
                               borderColour="#6450cd",
                               focusColour="#ccc2ff",
                               appearance=BTN_RND_RECTANGLE,
                               borderSize=1, size=(180, 100), pos=(100, 160),
                               image="./bitmaps/filesave.png", 
                               image_position='left', 
                               text_alignment='left',
                               )
        #self.button10.SetToolTip("This is button 10")
        #self.button10.Enable(False)
        
        self.button11 = Button(self.panel, id=-1, label="Button 11\nHello", normalLabelColour="#ffffff",
                               hoverLabelColour="#ffffff", pressedLabelColour="#ffffff",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                               normalBtnColour=(wx.Colour(90, 173, 255, 255), wx.Colour(5, 114, 255, 255)),
                               hoverBtnColour="#46a0f5",
                               pressedBtnColour="#1473e6", disabledBtnColour="#838383",
                               borderColour="#ffffff",
                               focusColour="#89c0f7",
                               appearance=BTN_RND_RECTANGLE,
                               borderSize=3, size=(100, 100), pos=(100, 280),
                               image="./bitmaps/filesave.png", 
                               image_position='bottom', 
                               text_alignment='center',
                               )
        #self.button11.SetToolTip("This is button 11")
        #self.button11.Enable(False)

        self.button12 = Button(self.panel, id=-1, label="Button 12", normalLabelColour="yellow",
                               hoverLabelColour="#ffffff", pressedLabelColour="gray",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                               normalBtnColour=(wx.Colour(90, 173, 255, 255), wx.Colour(5, 114, 255, 255)),
                               hoverBtnColour="#46a0f5",
                               pressedBtnColour="#1473e6", disabledBtnColour="#838383",
                               borderColour="#ffffff",
                               focusColour="#89c0f7",
                               appearance=BTN_RND_RECTANGLE,
                               borderSize=3, size=(120, 50), pos=(100, 400),
                               image="./bitmaps/filesave.png", 
                               image_position='right', 
                               )
        #self.button12.SetToolTip("This is button 12")
        #self.button12.Enable(False)
        
        self.button9.Bind(wx.EVT_BUTTON, self.OnButton)  # Bind the event handler to each button
        self.button10.Bind(wx.EVT_BUTTON, self.OnButton)
        self.button11.Bind(wx.EVT_BUTTON, self.OnButton)
        self.button12.Bind(wx.EVT_BUTTON, self.OnBtnClose)
        self.panel.Bind(wx.EVT_LEFT_DOWN, self.OnPanelClick)  # Event to manage focus when clicking on the panel 
        self.Bind(wx.EVT_BUTTON, self.OnControlClick)
        self.Bind(wx.EVT_ACTIVATE, self.OnActivate)  # Event to handle focus when clicking on the title bar
        
    def GetButtonFontSize(self):
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font_size = font.GetPointSize()
    
        # Dictionary for size adjustments by platform  
        platform_adjustments = {
            '__WXMSW__': 1,
            '__WXGTK__': -1,
            '__WXMAC__': 2  
        }
    
        # Use get() to get the fit, or 0 if the platform is not specified
        adjustment = platform_adjustments.get(wx.Platform, 0)
  
        return font_size + adjustment  # Returns the adjusted font size

    def OnControlClick(self, event):
        # Manage focus on controls  
        self.focused_ctrl = event.GetEventObject()
        self.focused_ctrl.SetFocus()
        
    def OnPanelClick(self, event):
        # Set focus on the control when the panel is clicked   
        self.button12.SetFocus()
        # Set focus on the control when the window is activated
        if self.focused_ctrl:  # Give focus to the last selected control  
            self.focused_ctrl.SetFocus()
        event.Skip()  # Allows events to continue to be processed

    def OnActivate(self, event):
        if event.GetActive():
            self.button12.SetFocus()
            # Set focus on the control when the window is activated  
            if self.focused_ctrl:  # Give focus to the last selected control  
                self.focused_ctrl.SetFocus()
            self.Refresh()
        event.Skip()  # Allows events to continue to be processed
        
    def OnButton(self, event):
        obj = event.GetEventObject()
        label = obj.GetLabel().strip()
        print(label, "pressed")
        event.Skip()

    def OnBtnClose(self, event):
        print("Close dialog")
        self.Close()
        
app = wx.App()
frame = Frame()
frame.Show()
app.MainLoop()
