import wx
from   button import Button

#-------------------------------------------------------------------------------
# Constants
#-------------------------------------------------------------------------------
BTN_RND_RECTANGLE = 20   # Define new appearance constants
BTN_RECTANGLE     = 21


class Frame(wx.Frame):
    def __init__(self):
        super().__init__(None, -1, "Simple demo - 2", size=(300, 600),
                         style=wx.DEFAULT_FRAME_STYLE |
                         wx.NO_FULL_REPAINT_ON_RESIZE)

        # Initialisation  
        self.focused_ctrl = False
        
        self.panel = wx.Panel(self)
        self.panel.SetBackgroundColour("#202020")
        self.panel.SetDoubleBuffered(True)

        # System font size
        ft_size = self.GetButtonFontSize()
        
        self.button5 = Button(self.panel, id=-1, label="Button 5", normalLabelColour="#000000",
                               hoverLabelColour="#000000", pressedLabelColour="#000000",
                               font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                               normalBtnColour=(wx.Colour(146, 193, 48, 255), wx.Colour(75, 120, 21, 255)), 
                               hoverBtnColour="#92c130",
                               pressedBtnColour="#4b7815", disabledBtnColour="#838383",
                               borderColour="#ffffff",
                               focusColour="#fdf240",
                               indicatorColour="#ffffff", appearance=BTN_RECTANGLE,
                               borderSize=3, size=(100, 30), pos=(100, 100),
                               )
        #self.button5.SetToolTip("This is button 5")
        #self.button5.Enable(False)
        self.button5.SetFocus()
        
        self.button6 = Button(self.panel, id=-1, label="Button 6", normalLabelColour="#46a0f5",
                              hoverLabelColour="#ffffff", pressedLabelColour="#ffffff",
                              font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                              normalBtnColour=(wx.Colour(255, 255, 255, 255), wx.Colour(255, 255, 255, 255)),
                              hoverBtnColour="#46a0f5",
                              pressedBtnColour="#1473e6", disabledBtnColour="#838383",
                              borderColour="#46a0f5",
                              focusColour="#1473e6",
                              indicatorColour="#ffffff", appearance=BTN_RECTANGLE,
                              borderSize=3, size=(120, 50),
                              image="./bitmaps/phoenix_title.png", pos=(100, 200),
                              image_position='left' 
                              )
        #self.button6.SetToolTip("This is button 6")
        #self.button6.Enable(False)
        
        self.button7 = Button(self.panel, id=-1, label="Button 7", normalLabelColour="#ffffff",
                              hoverLabelColour="#000000", pressedLabelColour="#ffffff",
                              font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                              normalBtnColour=(wx.Colour(146, 193, 48, 255), wx.Colour(75, 120, 21, 255)), 
                              hoverBtnColour="#92c130",
                              pressedBtnColour="#4b7815", disabledBtnColour="#838383",
                              borderColour="#ffffff",
                              focusColour="#fdf240",
                              indicatorColour="#ffffff", appearance=BTN_RECTANGLE,
                              borderSize=3, size=(100, 30), pos=(100, 300),
                              image="./bitmaps/item_empty.png", 
                              image_position='left' 
                              )
        #self.button7.SetToolTip("This is button 7")
        #self.button7.Enable(False)

        self.button8 = Button(self.panel, id=-1, label="Button 8", normalLabelColour="#ffffff",
                              hoverLabelColour="#000000", pressedLabelColour="#ffffff",
                              font_size=ft_size, font_weight=wx.FONTWEIGHT_BOLD,
                              normalBtnColour=(wx.Colour(146, 193, 48, 255), wx.Colour(75, 120, 21, 255)), 
                              hoverBtnColour="#92c130",
                              pressedBtnColour="#4b7815", disabledBtnColour="#838383",
                              borderColour="#ffffff",
                              focusColour="#fdf240",
                              indicatorColour="#ffffff", appearance=BTN_RECTANGLE,
                              borderSize=3, size=(120, 55), pos=(100, 400),
                              image="./bitmaps/item_quit.png", 
                              image_position='top' 
                              )
        #self.button8.SetToolTip("This is button 8")
        #self.button8.Enable(False)
        
        self.button5.Bind(wx.EVT_BUTTON, self.OnButton)  # Bind the event handler to each button
        self.button6.Bind(wx.EVT_BUTTON, self.OnButton)
        self.button7.Bind(wx.EVT_BUTTON, self.OnButton)
        self.button8.Bind(wx.EVT_BUTTON, self.OnBtnClose)
        self.panel.Bind(wx.EVT_LEFT_DOWN, self.OnPanelClick)  # Event to manage focus when clicking on the panel 
        self.Bind(wx.EVT_BUTTON, self.OnControlClick)
        self.Bind(wx.EVT_ACTIVATE, self.OnActivate)  # Event to handle focus when clicking on the title bar
        
    def GetButtonFontSize(self):
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font_size = font.GetPointSize()
    
        # Dictionary for size adjustments by platform  
        platform_adjustments = {
            '__WXMSW__': 1,
            '__WXGTK__': -1,
            '__WXMAC__': 2  
        }
    
        # Use get() to get the fit, or 0 if the platform is not specified
        adjustment = platform_adjustments.get(wx.Platform, 0)
  
        return font_size + adjustment  # Returns the adjusted font size

    def OnControlClick(self, event):
        # Manage focus on controls  
        self.focused_ctrl = event.GetEventObject()
        self.focused_ctrl.SetFocus()
        
    def OnPanelClick(self, event):
        # Set focus on the control when the panel is clicked   
        self.button8.SetFocus()
        # Set focus on the control when the window is activated
        if self.focused_ctrl:  # Give focus to the last selected control  
            self.focused_ctrl.SetFocus()
        event.Skip()  # Allows events to continue to be processed

    def OnActivate(self, event):
        if event.GetActive():
            self.button8.SetFocus()
            # Set focus on the control when the window is activated  
            if self.focused_ctrl:  # Give focus to the last selected control  
                self.focused_ctrl.SetFocus()
            self.Refresh()
        event.Skip()  # Allows events to continue to be processed
        
    def OnButton(self, event):
        obj = event.GetEventObject()
        label = obj.GetLabel().strip()
        print(label, "pressed")
        event.Skip()

    def OnBtnClose(self, event):
        print("Close dialog")
        self.Close()
        
app = wx.App()
frame = Frame()
frame.Show()
app.MainLoop()
